function test_suite = testTrace %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
assertTrue(isempty(trace(x)))

function testDefault
x = polysym;
assertEqual(trace(x),x)

function testScalar
x = polysym(pi);
assertEqual(trace(x),x)

function testUnequalDims
x = polysym('x',[1 3]);
f = @() trace(x);
assertExceptionThrown(f,'polysym:trace:square')

function testMatrix
x = polysym('x',2);
assertEqual(trace(x),x(1,1)+x(2,2))
